<?php

namespace App\Http\Resources\API\Event;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventDayResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        $data = [
            'id' => $this->id,
            'name' => $this->name,
            'date' => $this->date,
        ];

        if ($request->display_event_venues_details) {
            $data = array_merge($data, [
                'event_venues' => EventVenueResource::collection($this->eventVenues),
            ]);
        }

        if ($request->display_event_session_details) {
            $data = array_merge($data, [
                // 'event_sessions' => EventSessionResource::collection($this->eventParentSessions),
                'event_sessions' => EventSessionResource::collection(
                    $this->eventParentSessions->sortBy(function ($session) {
                        return strtolower($session->eventHall->name ?? '');
                    })
                ),
            ]);
        }

        return $data;
    }
}
