<?php

namespace App\Http\Resources\API\Event;

use App\Models\EventSessionUser;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventDesignationResource extends JsonResource
{

    protected $sessionId;

    public function __construct($resource, $sessionId = null)
    {
        parent::__construct($resource);
        $this->sessionId = $sessionId;
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        $eventSessionUsers = [];
        if ($this->sessionId) {
            $eventSessionUsers = $this->eventSessionUsers()->where('event_session_id', $this->sessionId)
                ->where('title', '!=', null)->get();
        }
        return [
            'designation' => $this->designation,
            'event_session_users' => EventSessionUserResource::collection($eventSessionUsers),
        ];
    }
}
