<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\UserResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventSessionQuestionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'question' => $this->question,
            'from' => [
                'id' => $this->fromUser->id ?? null,
                'name' => $this->fromUser->name ?? null,
            ],
            'to' => [
                'id' => $this->toUser->id ?? null,
                'name' => $this->toUser->name ?? null,
            ],
            'created_at' => $this->created_at,
        ];
    }
}
