<?php

namespace App\Http\Resources\API\Event;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Auth;

class EventSessionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $user = User::find($request->user_id);
        $event = $this->event;

        if ($this->parent_id == null) {
            $parent = $this->load('subSessions.questions');
            $questions = $parent->subSessions->flatMap(function ($subSession) {
                return $subSession->questions;
            });
        } else {
            $questions = $this->questions;
        }

        $request->merge(['event_session_id' => $this->id]);

        $sessionId = $this->id;
        $data = [
            'id' => $this->id,
            'title' => $this->title,
            'topic' => $this->topic,
            'start_time' => $this->start_time,
            'end_time' => $this->end_time,
            'status' => $this->status,
            'notes' => $this->notes,
            'ask_questions' => $this->ask_questions,
            'event_id' => $this->event_id ?? null,
            'event_hall' => $this->eventHall->name ?? null,
            'event_day_date' => $this->eventDay->date ?? null,
            'event_day' => $this->eventDay ?? null,
            'moderator' => $this->moderator,
            'bookmarked' => $user ? $this->isBookmarkedByUser($user) : 0,
            // 'event_designations' => EventDesignationResource::collection($event->eventDesignations),
            'event_designations' => $event->eventDesignations->map(function ($designation) use ($sessionId) {
                return new EventDesignationResource($designation, $sessionId);
            }),
            'event_faculties' => EventFacultyResource::collection($this->eventSessionFaculties),
            'sub_sessions' => EventSessionResource::collection($this->subSessions),
            'questions' => EventSessionQuestionResource::collection($questions),
        ];

        if ($request->display_event_session_speaker_details) {
            $data = array_merge($data, [
                'event_session_speakers' => SpeakerResource::collection($this->eventSessionSpeakers),
            ]);
        }

        return $data;
    }
}
