<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\UserResource;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

use function PHPUnit\Framework\isInstanceOf;

class EventSessionUserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        if ($this->user instanceof User) {
            $user = $this->user;
        } else {
            $user = $this;
        }

        return [
            'id' => $user->id ?? null,
            'name' => $user->name ?? null,
            'title' => $this->title ?? null,
        ];
    }
}
