<?php

namespace App\Http\Resources\API\Event;

use App\Http\Resources\API\MediaResource;
use App\Models\EventSession;
use App\Models\EventSessionUser;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SpeakerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $routeName = $request->route()->uri();        
        $user = $this;
        $data = [
            'id' => $user->id ?? '' ?? null,
            'title' => $this->title,
            // 'name' => $user->name ?? null,
            'name' => $routeName == 'api/events/sessions'? $user->full_name : $user->name ?? null,
            'email' => $user->email ?? null,
            'country_code' => $user->country_code ?? null,
            'contact' => $user->contact ?? null,
            'institute' => $user->institute ?? null,
            'designation' => $user->designation ?? null,
            'personal_info' => $user->personal_info ?? null,
            'text_1' => $user->text_1 ?? null,
            'text_2' => $user->text_2 ?? null,
            'bio' => $user->bio ?? null,
            'extra' => $user->extra ?? null,
            'type' => new EventSpeakerTypeResource($user->type),
            'cv' => $user->memberDetail->cv ?? null,
            'image' => new MediaResource($user->image),
        ];

        if ($request->event_id && $request->display_event_session_details) {
            $eventSessionIds = EventSessionUser::where('event_speaker_id', $user->id)
                ->whereHas('eventSessions', function ($query) use ($request) {
                    $query->where('event_id', $request->event_id);
                })
                ->pluck('event_session_id');
            $eventSessions = EventSession::whereIn('id', $eventSessionIds)->get();

            $data = array_merge($data, [
                'event_sessions' => EventSessionResource::collection($eventSessions),
            ]);
        }

        return $data;
    }
}
