<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EventResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'association_id' => $this->association_id,
            'title' => $this->title,
            'description' => $this->description,
            'date' => $this->date,
            'media' => new MediaResource($this->banner),
            'type' => $this->type,
            'link' => $this->link,
            'status' => $this->status,
        ];
    }
}
