<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PollResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $data = [
            'id' => $this->id,
            'association_id' => $this->association_id,
            'question' => $this->question,
            'options' => PollOptionResource::collection($this->pollOptions),
            'start_date' => $this->start_date,
            'start_time' => $this->start_time,
            'expire_time' => $this->expire_time,
            'expire_date' => $this->expire_date,
            'declare' => $this->declare
        ];

        return $data;
    }
}
