<?php

namespace App\Http\Resources\API;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PostCommentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {
        return [
            'id' => $this->id ?? null,
            'user' => $this->user ? new UserResource($this->user) : null,
            'post_id' => $this->post_id ?? null,
            'comment' => $this->comment ?? null,
            'created_at' => getTimezoneDateTime($this->created_at , 'Y-m-d H:i:s'),
        ];
    }
}
