<?php

namespace App\Http\Resources;

use App\Http\Resources\API\MediaResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InternationalAffiliationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'index' => $this->index,
            'association' => $this->association_id ?? null,
            'name' => $this->name ?? null,
            'link' => $this->link ?? null,
            'image' => $this->image ? new MediaResource($this->image): null,
            'status' => $this->status ?? null,
        ];
    }
}
