<?php

namespace App\Imports;

use App\Enums\RoleEnum;
use App\Enums\StatusEnum;
use App\Models\MemberRole;
use App\Models\User;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Hash;

class DataImport implements ToCollection
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $collection)
    {
        try {
            Log::info('Data Adding Starts...');
            DB::beginTransaction();

            $association = User::where('association_code', 'OGQOAE')
                ->where('role', RoleEnum::ASSOCIATION)->first();

            if (!$association) {
                Log::info('No Association Found...');
                return;
            }
            $memberRole = MemberRole::where('name', 'Members')
                ->where('association_id', $association->id)
                ->where('status', StatusEnum::ACTIVE)->first();

            foreach ($collection as $key => $row) {
                if ($key == 0) {
                    continue;
                }

                if ($row[3]) {
                    if (User::where('email', $row[3])->exists()) {
                        Log::info('Email Already Exists... :' . $row[3]);
                        continue;
                    }
                }

                $valueString = (string) $row[4];
                $onlyDigits = str_replace(['.', ' '], '', $valueString);
                $firstTenDigits = (int) substr($onlyDigits, 0, 10);

                // dd($collection[0], $row, $association, $memberRole);

                $user = User::updateOrCreate(
                    [
                        'email' => $row[3] ?? null,
                    ],
                    [
                        'unique_id' => $row[0],
                        'name' => $row[2],
                        'role' => RoleEnum::MEMBER,
                        'association_id' => $association->id,
                        'country_code' => "+91",
                        'contact' => $firstTenDigits ?? null,
                        'password' => Hash::make('123456'),
                    ]
                );

                $extra = [
                    'mbbs_certificate' => $row[5],
                    'md_certificate' => $row[6],
                    'dm_certificate' => $row[7],
                    'md2_certificate' => $row[8],
                ];
                $extra = cleanseArray($extra);

                $extra = array_map(function ($extr) {
                    return 'https://endocrinesocietyindia.org/' . $extr;
                }, $extra);

                $extra['category'] = $row[1];
                $userDetail['member_id'] = $user->id;
                $userDetail["association_id"] = $association->id;
                $userDetail["role_id"] = $memberRole->id ?? null;
                $userDetail["extra"] = $extra ?? [];
                $user->memberDetail()->updateOrCreate($userDetail);
                DB::commit();
            }
            Log::info('Data Adding Ends...');
        } catch (\Exception $exception) {
            Log::info("Data Adding Error : " . $exception->getMessage());
            DB::rollBack();
        }
    }
}
