<?php

namespace App\Imports;

use App\Enums\TitleEnum;
use App\Models\EventSpeaker;
use App\Rules\DisposableEmailRule;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Facades\Log;

class EventSpeakerImport implements ToCollection
{
    private $eventId;

    public function __construct($eventId)
    {
        $this->eventId = $eventId;
    }

    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    {
        Log::info('Speaker Import Start.');
        $i = 0;
        foreach ($rows as $key => $row) {
            if ($key == 0) {
                continue;
            }

            $disposableEmailRule = new DisposableEmailRule();
            if (!($row[0]) || !($row[1]) || !($row[2])) {
                continue;
            }

            $titles = [
                'Dr.' => TitleEnum::DR,
                'Prof.' => TitleEnum::PROF,
                'Mr.' => TitleEnum::MR,
                'Ms.' => TitleEnum::MS,
                'Mrs.' => TitleEnum::MRS,
            ];

            $title = $titles[$row[0]] ?? TitleEnum::DR;

            EventSpeaker::updateOrCreate([
                'contact' => $row[2] ?? '',
            ], [
                'event_id' => $this->eventId,
                'title' => $title ?? '',
                'name' => $row[1] ?? '',
                'institute' => $row[3] ?? '',
                'designation' => $row[4] ?? '',
                'personal_info' => $row[5] ?? '',
                'text_1' => $row[6] ?? '',
                'text_2' => $row[7] ?? '',
                'bio' => $row[8] ?? '',
            ]);
            Log::info('Count : ' . $i++);
        }
        Log::info('Speaker Import Ends.');
    }
}
