<?php

namespace App\Models;

use App\Enums\AdminLevel;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Admin extends Authenticatable
{
    use HasFactory;

    protected $fillable = [
        'association_id',
        'name',
        'email',
        'country_code',
        'contact',
        'pin',
        'password',
        'status',
        'mobile_number',
        'role',
        'photo',
        'permission_level',
    ];

    protected $hidden = [
        'pin',
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function scopeFilterEventManager($query)
    {
        if (request()->filled('filter')) {
            $query->where('name', 'like', '%' . request('filter') . '%')
                ->orWhere('email', 'like', '%' . request('filter') . '%');
        }
    }

    public function eventManager()
    {
        return $this->hasOne(EventManager::class, 'admin_id');
    }

    // public function eventManagers()
    // {
    //     return $this->where('role', AdminLevel::EVENT_COORDINATOR)
    //         ->hasMany(EventManager::class, 'admin_id');
    // }

    public function getFullMobileNumberAttribute()
    {
        return "$this->country_code $this->contact";
    }

}
