<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssociationNotification extends Model
{
    use HasFactory;

    protected $fillable = [
        'association_id',
        'title',
        'body',
    ];

    protected static function booted()
    {
        static::addGlobalScope('orderById', function (Builder $builder) {
            $builder->orderByDesc('id');
        });
    }
}
