<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CommitteeMember extends Model
{
    use HasFactory;

    protected $fillable = [
        'commity_id',
        'member_id',
        'association_id',
        'index'
    ];

    public function member()
    {
        return $this->belongsTo(User::class, 'member_id');
    }

    public function committee()
    {
        return $this->belongsTo(Committee::class, 'commity_id');
    }
}
