<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class EventActivity extends Model
{
    use HasFactory;
    protected $fillable = [
        'event_id',
        'name',
        'title',
        'description',
        'link',
        'media_ids',
        'index',
    ];

    protected $cast = [
        'media_ids' => 'array',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    // Global scope to order by index ascending
    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }

}
