<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class EventCommittee extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'name',
        'status',
        'index'
    ];

    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }
}
