<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Builder;

class EventDay extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'name',
        'date',
        'text_color',
        'bg_color',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
        'status',
        'event_id',
    ];

    // Global scope to order by index ascending
    protected static function booted()
    {
        static::addGlobalScope('orderByDate', function (Builder $builder) {
            $builder->orderBy('date');
        });
    }

    /**
     * @return BelongsTo
     */
    public function event(): BelongsTo
    {
        return $this->BelongsTo(Event::class, 'event_id');
    }

    /**
     * Get all of the event venues for the EventDay
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function eventVenues(): HasMany
    {
        return $this->hasMany(EventVenue::class, 'event_day_id');
    }

    /**
     * Get all of the event sessions for the EventDay
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function eventSessions(): HasMany
    {
        return $this->hasMany(EventSession::class, 'event_day_id');
    }

    public function eventParentSessions()
    {
        return $this->hasMany(EventSession::class, 'event_day_id')->whereNull('parent_id');
    }
}
