<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EventExhibitor extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'company_name',
        'sponsor_type',
        'event_exhibitor_category_id',
        'contact',
        'email',
        'website_link',
        'brochure_link',
        'about',
        'connect',
        'address',
        'stall',
        'media_id',
        'event_hall_id',
        'event_id',
    ];

    /**
     * @return BelongsTo
     */
    public function event(): BelongsTo
    {
        return $this->belongsTo(Event::class, 'event_id');
    }

    /**
     * @return BelongsTo
     */
    public function eventHall(): BelongsTo
    {
        return $this->belongsTo(EventHall::class, 'event_hall_id');
    }

    public function scrollerImages()
    {
        return $this->morphMany(ScrollerImage::class, 'imageable');
    }

    public function logo(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'media_id');
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(EventExhibitorCategory::class, 'event_exhibitor_category_id');
    }
}
