<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventFaculty extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'title',
        'email',
        'name',
        'country_code',
        'contact',
        'institute',
        'designation',
        'personal_info',
        'text_1',
        'text_2',
        'bio',
        'media_id',
    ];

    public function getFullNameAttribute()
    {
        return "$this->title $this->name";
    }

    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    public function image()
    {
        return $this->belongsTo(Media::class, 'media_id');
    }
}
