<?php

namespace App\Models;

use App\Enums\EventFormFieldEnum;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EventFormInputField extends Model
{
    use HasFactory;

    protected $fillable = [
        "event_id",
        "display_label",
        "field",
        "type",
	    "label",
	    "name",
        "index",
	    "required",
	    "default_value",
	    "helper_text",
	    "options",
	    "visible",
        "field_type"
    ];
    protected $casts = [
        'options' => 'array',
    ];

    protected $hidden = [
        'id',
        'field_accept_value',
        'created_at',
        'updated_at',
    ];

    protected $appends = [
        'accepted_value'
    ];

    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }

    public function getAcceptedValueAttribute()
    {
        return match ($this->field_accept_value) {
            EventFormFieldEnum::FIELD_ACCEPT_ALPHA_NUMBERIC => "Alpha Numeric",
            EventFormFieldEnum::FIELD_ACCEPT_ALPHABETS => "Alphabets",
            EventFormFieldEnum::FIELD_ACCEPT_NUMBERIC => "Numeric",
            EventFormFieldEnum::FIELD_ACCEPT_IMAGE => "image/*",
            default => "",
        };
    }

    public function event(): BelongsTo
    {
        return $this->belongsTo(Event::class, 'event_id');
    }
}
