<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class EventFormSlab extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'name',
        'start_date',
        'start_time',
        'end_date',
        'end_time',
        'status',
        'index'
    ];

    public function eventSlabCategories(): HasMany
    {
        return $this->hasMany(EventFormSlabCategory::class, 'event_form_slab_id');
    }

}
