<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EventManager extends Model
{
    use HasFactory;

    protected $fillable = [
        'association_id',
        'event_id',
        'admin_id',
    ];

    public function scopeFilter($query)
    {
        if (request()->filled('filter')) {
            $query->whereHas('admin', function ($query) {
                $query->where('name', 'like', '%' . request('filter') . '%')
                    ->orWhere('email', 'like', '%' . request('filter') . '%');
            });
        }
    }


    public function event(): BelongsTo
    {
        return $this->BelongsTo(Event::class, 'event_id');
    }

    public function admin(): BelongsTo
    {
        return $this->BelongsTo(Admin::class, 'admin_id');
    }
}
