<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EventPage extends Model
{
    use HasFactory;
    protected $fillable = [
        'event_id',
        'type',
        'description',
        'media_ids'
    ];


    public function getMedia()
    {
        $mediaIds = explode(',', $this->media_ids);

        $mediaCollection = Media::whereIn('id', $mediaIds)->get();

        return $mediaCollection->map(function ($media) {
            return [
                'id' => $media->id,
                'name' => $media->name,
                'path' => getFilePath($media->path),
            ];
        });
    }

    public function getButtons()
    {
        return $this->hasMany(EventButton::class, 'event_id', 'event_id');
    }

    public function getButtonsResponse()
    {
        return $this->getButtons()->select('name', 'link', 'index');
    }

    public function getLocations()
    {
        return $this->hasMany(EventLocation::class, 'event_id', 'event_id');
    }

    public function getLocationsResponse()
    {
        $locations = $this->getLocations()->select('id', 'name', 'description', 'index', 'media_ids', 'extra')->get();

        return $locations->map(function ($location) {
            $media = $location->getMedia();

            return [
                'id' => $location->id,
                'name' => $location->name,
                'description' => $location->description,
                'index' => $location->index,
                'extra' => $location->extra ?? [],
                'media' => $media,
            ];
        });
    }
}
