<?php

namespace App\Models;

use App\Helpers\PaymentInterface;
use App\Helpers\RazorPay;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventPaymentMode extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'name',
        'app_key',
        'secret_key',
    ];

    const PAYMENT_MODE_RAZORPAY = "razorpay";
    const PAYMENT_MODE_PHONEPE = "phonepe";

    public function getPaymentClient()
    {
        return new RazorPay($this->app_key, $this->secret_key);
    }

    public function getCallback($referralId)
    {
        if ($this->name == self::PAYMENT_MODE_RAZORPAY) {
            return route('frontend.thanks', $referralId);
        }
        return $referralId;
    }
}
