<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Builder;

class EventSpeaker extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'email',
        'country_code',
        'contact',
        'media_id',
        'cv',
        'index',
        'status',
        'event_id',
        'title',
        'institute',
        'designation',
        'personal_info',
        'text_1',
        'text_2',
        'bio',
        'extra',
        'event_speaker_type_id',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
        'status',
    ];

    public function getFullNameAttribute()
    {
        return "$this->title $this->name";
    }
    // Global scope to order by index ascending
    // protected static function booted()
    // {
    //     static::addGlobalScope('orderByIndex', function (Builder $builder) {
    //         $builder->orderBy('index');
    //     });
    // }

    /**
     * @return BelongsTo
     */
    public function image(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'media_id');
    }

    /**
     * @return BelongsTo
     */
    public function association(): BelongsTo
    {
        return $this->belongsTo(User::class, 'association_id');
    }

    /**
     * @return BelongsTo
     */
    public function event(): BelongsTo
    {
        return $this->BelongsTo(Event::class, 'event_id');
    }

    public function type(): BelongsTo
    {
        return $this->BelongsTo(EventSpeakerType::class, 'event_speaker_type_id');
    }
}
