<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class MemberDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'member_id',
        'association_id',
        'media_id',
        'role_id',
        'about',
        'dob',
        'extra',
        'message',
        'cv',
        'registration_number',
    ];

    protected $casts = [
        'extra' => 'array',
    ];

    public function image(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'media_id');
    }

    public function role(): BelongsTo
    {
        return $this->belongsTo(MemberRole::class, 'role_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'member_id');
    }

}
