<?php

namespace App\Models;

use App\Helpers\MetaClient;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\File\File;

class MessageTemplateComponent extends Model
{
    use HasFactory;

    protected $fillable = [
        "type",
        "text",
        "example_key",
        "dynamic_variables",
        "format",
        "document_url",
        "media_id",
    ];

    protected $casts = [
        "dynamic_variables" => "array",
    ];

    public function media(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'media_id');
    }

    public function getFacebookPayload()
    {
        $payload = [
            "type" => $this->type,
        ];

        if ($this->text) {
            $regix = "/\[{1}([^]]+)\]{1}/";
            $i = 0;
            $payload["text"] = preg_replace_callback(
                $regix,
                function ($match) use (&$i) {
                    $i++;
                    return "{{{$i}}}";
                },
                $this->text
            );
        }
        switch ($this->type) {
            case "HEADER":
                $payload["format"] = $this->format;
                if ($this->format === "TEXT") {
                    $variables = $this->dynamic_variables ?? [];
                    if (count($variables) > 0) {
                        $payload["example"] = [
                            "header_text" => array_values($variables)
                        ];
                    }
                } else {
                    $response = $this->uploadMedia();
                    $payload["example"] = [
                        "header_handle" => [
                            $response["h"]
                        ]
                    ];
                }
                break;

            case "BODY":
                $variables = $this->dynamic_variables ?? [];
                if (count($variables) > 0) {
                    $payload["example"] = [
                        "body_text" => [
                            array_values($variables)
                        ]
                    ];
                }
                break;

            case "PHONE_NUMBER":
                $payload["phone_number"] = $this->format;
                break;

            case "URL":
                $payload["url"] = $this->format;
                break;
        }
        return $payload;
    }

    public function uploadMedia()
    {
        if ($this->media) {
            Log::info("media : ".  $this->media->path);
            $api = new MetaClient();

            $path =  $this->media->path ? storage_path("app/public/" . $this->media->path) : '';
            Log::info("media path :: " . $path);

            $file = new File($path);
            $response = $api->createUploadSession($file->getSize(), $file->getMimeType());
            $session = $response->json();
            $response = $api->uploadMedia($session["id"], $file);
            return $response->json();
        }
        return null;
    }
}
