<?php

namespace App\Observers;

use App\Models\MailTemplateCampaign;

class MailTemplateCampaignObserver
{
    /**
     * @param MailTemplateCampaign $mailTemplateCampaign
     */
    public function creating(MailTemplateCampaign $mailTemplateCampaign)
    {
        $mailTemplateCampaign->success_users = [];
        $mailTemplateCampaign->fail_users = [];
        $mailTemplateCampaign->scheduled_at = date('Y-m-d H:i',
            strtotime($mailTemplateCampaign->scheduled_date . ' ' . $mailTemplateCampaign->scheduled_time));
    }
    /**
     * Handle the MailTemplateCampaign "created" event.
     */
    public function created(MailTemplateCampaign $mailTemplateCampaign): void
    {
        //
    }

    /**
     * Handle the MailTemplateCampaign "updated" event.
     */
    public function updated(MailTemplateCampaign $mailTemplateCampaign): void
    {
        //
    }

    /**
     * Handle the MailTemplateCampaign "deleted" event.
     */
    public function deleted(MailTemplateCampaign $mailTemplateCampaign): void
    {
        //
    }

    /**
     * Handle the MailTemplateCampaign "restored" event.
     */
    public function restored(MailTemplateCampaign $mailTemplateCampaign): void
    {
        //
    }

    /**
     * Handle the MailTemplateCampaign "force deleted" event.
     */
    public function forceDeleted(MailTemplateCampaign $mailTemplateCampaign): void
    {
        //
    }
}
