<?php

namespace App\Observers;

use App\Models\PostComment;

class PostCommentObserver
{
    protected string $targetColumn = "comment_count";

    /**
     * Handle the PostComment "created" event.
     */
    public function created(PostComment $postComment): void
    {
        $post = $postComment->post;
        $post->increment($this->targetColumn);
    }

    /**
     * Handle the PostComment "updated" event.
     */
    public function updated(PostComment $postComment): void
    {
        //
    }

    /**
     * Handle the PostComment "deleted" event.
     */
    public function deleted(PostComment $postComment): void
    {
        $post = $postComment->post;
        $post->decrement($this->targetColumn);
    }

    /**
     * Handle the PostComment "restored" event.
     */
    public function restored(PostComment $postComment): void
    {
        $post = $postComment->post;
        $post->increment($this->targetColumn);
    }

    /**
     * Handle the PostComment "force deleted" event.
     */
    public function forceDeleted(PostComment $postComment): void
    {
        $post = $postComment->post;
        $post->decrement($this->targetColumn);
    }
}
