<?php

namespace App\Observers;

use App\Models\PostLike;

class PostLikeObserver
{
    protected string $targetColumn = "like_count";

    /**
     * Handle the PostLike "created" event.
     */
    public function created(PostLike $postLike): void
    {
        $post = $postLike->post;
        $post->increment($this->targetColumn);
    }

    /**
     * Handle the PostLike "updated" event.
     */
    public function updated(PostLike $postLike): void
    {
        //
    }

    /**
     * Handle the PostLike "deleted" event.
     */
    public function deleted(PostLike $postLike): void
    {
        $post = $postLike->post;
        $post->decrement($this->targetColumn);
    }

    /**
     * Handle the PostLike "restored" event.
     */
    public function restored(PostLike $postLike): void
    {
        $post = $postLike->post;
        $post->increment($this->targetColumn);
    }

    /**
     * Handle the PostLike "force deleted" event.
     */
    public function forceDeleted(PostLike $postLike): void
    {
        $post = $postLike->post;
        $post->decrement($this->targetColumn);
    }
}
