<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('membership_form_fields', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("association_id")->nullable();
            $table->foreign("association_id")->references("id")->on("users");
            $table->string('label');
            $table->string('name');
            $table->string('default_value')->nullable();
            $table->tinyInteger('field_accept_value')->nullable()->comment("1=> Only Alphabets 2=> aplha numeric 3=> Only Numeric");
            $table->text('helper_text')->nullable();
            $table->integer('index')->default(1);
            $table->string('type');
            $table->tinyInteger('required')->default(0);
            $table->json('options')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('membership_form_fields');
    }
};
