<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('members')) {
            Schema::create('members', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger("association_id")->nullable();
                $table->foreign("association_id")->references("id")->on("users");
                $table->string('name')->nullable();
                $table->bigInteger('mobile')->nullable();
                $table->string('country_code')->nullable();
                $table->longText('about')->nullable();
                $table->unsignedBigInteger("media_id")->nullable();
                $table->foreign("media_id")->on("media")->references("id");
                $table->unsignedBigInteger("role_id")->nullable();
                $table->foreign("role_id")->on("member_roles")->references("id");
                $table->tinyInteger('status')->default(StatusEnum::ACTIVE)->comment('1 => Active, 0 => Deactive');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('members')) {
            Schema::dropIfExists('members');
        }
    }
};
