<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('message_templates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("association_id")->nullable();
            $table->foreign("association_id")->references("id")->on("users");
            $table->string('template_id')->nullable();
            $table->longText('name');
            $table->string('language');
            $table->string('category')->comment('AUTHENTICATION, MARKETING, UTILITY');;
            $table->boolean('allow_category_change')->default(0);
            $table->date('schedule_date')->nullable();
            $table->time('schedule_time')->nullable();
            $table->string('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('message_templates');
    }
};
