<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('message_template_components', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('message_template_id')->comment('message_templates table')->nullable();
            $table->foreign('message_template_id')->references('id')->on('message_templates')->onDelete('cascade');
            $table->string('type')->comment('HEADER, BODY, FOOTER, BUTTONS');
            $table->string('format')->nullable()->comment('when HEADER is available');
            $table->longText('text')->nullable();
            $table->string('example_key')->nullable();
            $table->longText('dynamic_variables')->nullable();
            $table->string('document_url')->nullable();
            $table->unsignedBigInteger("media_id")->nullable();
            $table->foreign("media_id")->on("media")->references("id");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('message_template_components');
    }
};
