<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('message_campaigns', function (Blueprint $table) {
            $table->id();
            $table->string('template_name')->nullable();
            $table->string('campaign_unique_id')->nullable()->comment('unique id');
            $table->date('scheduled_date')->nullable();
            $table->time('scheduled_time')->nullable();
            $table->dateTime('scheduled_at')->nullable();
            $table->bigInteger('total_users')->nullable();
            $table->longText('users')->nullable();
            $table->longText('success_users')->nullable();
            $table->longText('fail_users')->nullable();
            $table->tinyInteger('status')->default(1)->comment('1=> pending, 2=>success')->nullable();
            $table->string('schedule_type')->default('send_now')->comment('send_now & send_later');
            $table->bigInteger('user_wallet_points')->default(0);
            $table->unsignedBigInteger('message_template_id')->nullable();
            $table->longText('sent_users')->nullable();
            $table->longText('delivered_users')->nullable();
            $table->longText('read_users')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('message_campaigns');
    }
};
