<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('message_campaign_users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("message_campaign_id");
            $table->unsignedBigInteger("user_id")->nullable();
            $table->unsignedBigInteger("message_id")->nullable();
            $table->string("contact", 20)->nullable();
            $table->string("meta_message_id", 100)->nullable();

            $table->string("status", 10)->default("PENDING");

            $table->timestamp("sent_at")->nullable();
            $table->timestamp("delivered_at")->nullable();
            $table->timestamp("read_at")->nullable();
            $table->timestamp("replied_at")->nullable();
            $table->text("message")->nullable();
            $table->timestamps();

            $table->foreign("message_campaign_id")->references("id")->on("message_campaigns");
            $table->foreign("user_id")->references("id")->on("members");
            // $table->foreign("message_id")->references("id")->on("messages");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('message_campaign_users');
    }
};
