<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'test_pin')) {
                $table->dropColumn('test_pin');
            }

            if (!Schema::hasColumn('users', 'pin')) {
                $table->string('pin', 10)->nullable()->after('password');
            }

            if (!Schema::hasColumn('users', 'code')) {
                $table->string('code', 10)->unique()->nullable()->after('pin');
            }

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'code')) {
                $table->dropColumn('code');
            }
            if (Schema::hasColumn('users', 'pin')) {
                $table->dropColumn('pin');
            }
        });
    }
};
