<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('membership_form_fields', function (Blueprint $table) {
            $table->dropColumn('deleted_at');
            $table->dropForeign(['association_id']);
            $table->foreign('association_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('membership_form_fields', function (Blueprint $table) {
            $table->dropForeign(['association_id']);
            $table->foreign('association_id')->references('id')->on('users');
            $table->timestamp('deleted_at')->nullable();
        });
    }
};
