<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("association_id");
            $table->foreign("association_id")->references("id")->on("users");
            $table->string('title');
            $table->tinyInteger('type');
            $table->timestamp('date');
            $table->text('description')->nullable();
            $table->string('link', 200)->nullable();
            $table->unsignedBigInteger("banner_id")->nullable();
            $table->foreign("banner_id")->on("media")->references("id");
            $table->tinyInteger('status')->default(StatusEnum::INACTIVE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('events');
    }
};
