<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('events', function (Blueprint $table) {
            $table->string('code')->nullable()->unique()->after('id');
            $table->unsignedBigInteger('message_template_id')->nullable()->after('status');
            $table->foreign('message_template_id')->references('id')->on('message_templates');
            $table->unsignedBigInteger('mail_template_id')->nullable()->after('message_template_id');
            $table->foreign('mail_template_id')->references('id')->on('mail_templates');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('events', function (Blueprint $table) {
            $table->dropColumn('code');
            $table->dropForeign(['message_template_id']);
            $table->dropForeign(['mail_template_id']);
            $table->dropColumn('message_template_id');
            $table->dropColumn('mail_template_id');
        });
    }
};
