<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('international_affiliations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("association_id")->nullable();
            $table->foreign("association_id")->references("id")->on("users");
            $table->string('name')->nullable();
            $table->string('link')->nullable();
            $table->unsignedBigInteger("media_id")->nullable();
            $table->foreign("media_id")->on("media")->references("id");
            $table->string('index')->default('0');
            $table->tinyInteger('status')->default(StatusEnum::ACTIVE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('international_affiliations');
    }
};
