<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('member_roles', function (Blueprint $table) {
            $table->dropForeign(['association_id']);
            $table->foreign("association_id")->references("id")->on("users")->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('member_roles', function (Blueprint $table) {
            $table->dropForeign(['association_id']);
            $table->foreign("association_id")->references("id")->on("users");
        });
    }
};
