<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_venues', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('event_day_id')->nullable();
            $table->foreign('event_day_id')->references('id')->on('event_days')->onDelete('cascade');
            $table->string('name')->nullable();
            $table->time('start_date_time')->nullable();
            $table->time('end_date_time')->nullable();
            $table->integer('index')->default(1);
            $table->json('extra')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_venues');
    }
};
