<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_committee_members', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('event_id')->nullable();
            $table->foreign('event_id')->references('id')->on('events')->cascadeOnDelete();
            $table->unsignedBigInteger("committee_id")->nullable();
            $table->foreign("committee_id")->on("event_committees")->references("id")->cascadeOnDelete();
            $table->unsignedBigInteger("member_id")->nullable();
            $table->foreign("member_id")->on("users")->references("id")->cascadeOnDelete();
            $table->unsignedBigInteger("role_id")->nullable();
            $table->foreign("role_id")->on("event_member_roles")->references("id")->nullOnDelete();
            $table->integer('index')->default(0)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_committee_members');
    }
};
