<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_faculties', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('event_id')->nullable();
            $table->foreign('event_id')->references('id')->on('events')->onDelete('cascade');
            $table->string('title')->nullable()->comment('Dr, Prof, Mr, Ms, Mrs');
            $table->string('email')->nullable();
            $table->string('name')->nullable();
            $table->string('country_code')->default('+91');
            $table->string('contact')->nullable();
            $table->string('institute')->nullable();
            $table->string('designation')->nullable();
            $table->string('personal_info')->nullable();
            $table->string('text_1')->nullable();
            $table->string('text_2')->nullable();
            $table->string('bio')->nullable();
            $table->unsignedBigInteger("media_id")->nullable();
            $table->foreign("media_id")->on("media")->references("id");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_faculties');
    }
};
