<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_sessions', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->text('topic')->nullable();
            $table->integer('sub_sessions')->nullable();
            $table->integer('sub_sessions_min')->nullable();
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->string('text_color', 7)->nullable()->comment('Hex value for text color (e.g., #FFFFFF)');
            $table->string('bg_color', 7)->nullable()->comment('Hex value for background color (e.g., #FF5733)');
            $table->tinyInteger('type')->nullable()->comment('1 => AUTO, 2 => MANUAL');
            $table->unsignedBigInteger('event_id')->nullable();
            $table->foreign('event_id')->references('id')->on('events')->cascadeOnDelete();
            $table->unsignedBigInteger('event_hall_id')->nullable();
            $table->foreign('event_hall_id')->references('id')->on('event_halls')->cascadeOnDelete();
            $table->unsignedBigInteger('event_day_id')->nullable();
            $table->foreign('event_day_id')->references('id')->on('event_days')->cascadeOnDelete();
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->foreign('parent_id')->references('id')->on('event_sessions')->cascadeOnDelete();
            $table->json('extra')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_sessions');
    }
};
