<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_session_questions', function (Blueprint $table) {
            $table->id();
            $table->text('question')->nullable();
            $table->foreignId('event_session_id')->nullable()->constrained()->cascadeOnDelete();
            $table->foreignId('from')->nullable()->constrained('users')->cascadeOnDelete();
            $table->foreignId('to')->nullable()->constrained('users')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_session_questions');
    }
};
