<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_exhibitors', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('country_code')->default('+91');
            $table->bigInteger('contact')->nullable();
            $table->string('email')->nullable();
            $table->string('website_link')->nullable();
            $table->string('brochure_link')->nullable();
            $table->text('about')->nullable();
            $table->text('connect')->nullable();
            $table->string('stall')->nullable();
            $table->foreignId('event_hall_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('event_id')->nullable()->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_exhibitors');
    }
};
