<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_e_posters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->nullable()->constrained()->cascadeOnDelete();
            $table->string('title')->nullable();
            $table->foreignId('presenter_id')->nullable()->constrained('users')->cascadeOnDelete();
            $table->string('abstract_id')->nullable();
            $table->json('co_author')->nullable();
            $table->string('institute')->nullable();
            $table->foreignId('event_e_poster_category_id')->nullable()->constrained('event_e_poster_categories')->cascadeOnDelete();
            $table->foreignId('poster_id')->nullable()->constrained('media')->cascadeOnDelete();
            $table->integer('index')->default(1);
            $table->tinyInteger('status')->default(StatusEnum::ACTIVE)->comment('1 => Active, 0 => Deactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_e_posters');
    }
};
